#include <stdio.h>
#include <math.h>

#define MAXN 200000

long long pozicija[MAXN], visina[MAXN];
double vrh_x[MAXN], vrh_y[MAXN];
double najbolje[MAXN];

double rastojanje(long long x1, long long y1, double x2, double y2) {
    double dx = x2 - x1;
    double dy = y2 - y1;
    return sqrt(dx*dx + dy*dy);
}

int main() {
    int n;
    scanf("%d", &n);

    int i;

    for (i = 0; i < n; i++) scanf("%lld", &pozicija[i]);
    for (i = 0; i < n; i++) scanf("%lld", &visina[i]);

    for (i = 0; i < n; i++) najbolje[i] = 1e100;

    for (i = 0; i + 1 < n; i++) {
        double xm = (pozicija[i] + visina[i] + pozicija[i+1] - visina[i+1]) * 0.5;
        if (xm < pozicija[i]) xm = pozicija[i];
        if (xm > pozicija[i+1]) xm = pozicija[i+1];
        double ym = visina[i] - (xm - pozicija[i]);
        vrh_x[i] = xm;
        vrh_y[i] = ym;
    }

    for (i = 0; i < n; i++) {
        if (i > 0 && visina[i-1] >= visina[i]) {
            double r = rastojanje(pozicija[i], visina[i], pozicija[i-1], visina[i-1]);
            if (r < najbolje[i]) najbolje[i] = r;
        }
        if (i + 1 < n && visina[i+1] >= visina[i]) {
            double r = rastojanje(pozicija[i], visina[i], pozicija[i+1], visina[i+1]);
            if (r < najbolje[i]) najbolje[i] = r;
        }
    }

    for (i = 0; i + 1 < n; i++) {
        if (vrh_y[i] >= visina[i]) {
            double r = rastojanje(pozicija[i], visina[i], vrh_x[i], vrh_y[i]);
            if (r < najbolje[i]) najbolje[i] = r;
        }
        if (vrh_y[i] >= visina[i+1]) {
            double r = rastojanje(pozicija[i+1], visina[i+1], vrh_x[i], vrh_y[i]);
            if (r < najbolje[i+1]) najbolje[i+1] = r;
        }
    }

    for (i = 0; i < n; i++) {
        if (najbolje[i] > 1e50) printf("-1\n");
        else printf("%.10f\n", najbolje[i]);
    }

    return 0;
}